<?php

include 'session.php';

if (isset($_GET['id'])) {

    $id = $_GET['id'];

    $q = "SELECT v.id, v.title, v.video, v.cover, v.views, v.user_id, u.name,u.profile,v.status
    FROM video v INNER JOIN users u ON v.user_id = u.id WHERE v.id = $id ORDER BY rand() limit 1";
    $res = mysqli_query($conn, $q);

    $r = mysqli_fetch_assoc($res);

    if ($r) {
        $id = $r['id'];
        $title = $r['title'];
        $video = "../videos/video/" . $r['video'];
        $cover = "../videos/thumbnail/" . $r['cover'];
        $views = $r['views'];
        $user_id = $r['user_id'];
        $name = $r['name'];
        $profile = $r['profile'];
        $status = $r['status'];
    } else {
        echo "=========================".mysqli_error($conn);
    }
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Video Player</title>
</head>

<style>
    .video video {
        display: block;
        margin: 20px auto 5px auto;
        border-radius: 20px;
        box-shadow: 0px 0px 5px 3px #1a1a1a;
        position: relative;
        z-index: 0;
    }

    .details {
        background-color: #f9f9f9;
        padding: 30px 20px;
        border-radius: 10px;
    }

    .details div {
        background-color: #e1e1e1;
        margin: 10px;
        border-radius: 10px;
        padding: 20px;
        word-wrap: break-word;
    }

    .details img {
        height: 200px;
        width: 200px;
        border-radius: 20px;
        display: block;
    }

    input[type=checkbox] {
        height: 30px;
        width: 30px;
        background-color: white;
    }

    label {
        cursor: pointer;
    }

    #publish {
        display: flex;
        justify-content: space-between;
    }


    /* ==============Media Query========== */
    @media screen and (min-width: 700px) {
        .video video {
            height: 70vh;
        }

    }

    @media screen and (max-width: 700px) {
        .video video {
            height: auto;
            width: 100%;
        }
    }
</style>

<body>
    <?php include_once('includes/header.php'); ?>


    <div class="video">

        <video src="<?php echo $video ?>" controls onloadstart="this.volume=0.2" poster="<?php echo $cover ?>"></video>

    </div>

    <div class="details">

        <div id="publish">
            <label for="status">
                Publish Video
            </label>
            <?php
            if ($status == "1") {
            ?>
                <td><input type="checkbox" checked onclick="publishVideo('<?php echo $id ?>',this)" id="status"></td>
            <?php
            } else {
            ?>
                <td><input type="checkbox" onclick="publishVideo('<?php echo $id ?>',this)" id="status"></td>
            <?php
            }
            ?>
        </div>

        <div>Video Title : <?php echo $title ?></div>

        <div>Video Views : <?php echo $views ?></div>


        <div>User Name : <?php echo $name ?></div>

        <div>
            <?php
            if (strlen($profile) > 10) {
            ?>
                <img src="<?php echo $profile ?>" alt="">
            <?php
            } else {
            ?>
                <td><img src="img/user.png"></td>
            <?php
            }
            ?>

        </div>



    </div>


    <script>
        function publishVideo(id, check) {
            if (check.checked) {
                setPublish(id, "1");
            } else {
                setPublish(id, "0");
            }
        }

        function setPublish(id, status) {

            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    console.log(xhttp.responseText);
                }
            };

            let url = "crud/crud_unpublish.php?id=" + id + "&status=" + status;
            xhttp.open("GET", url, true);
            xhttp.send();
            
        }
    </script>



    <?php include_once('includes/footer.php'); ?>