<?php
include 'session.php';

if (isset($_GET['page'])) {
    $page = $_GET['page'];
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}
$per_page = 30;
$start = ($page - 1) * $per_page;

$users;
if (isset($_GET['q'])) {
    $search = $_GET['q'];

    $quser = "SELECT `id`, `profile`, `name`,`status` FROM `users` 
    WHERE (lower(email) LIKE lower('%$search%') || lower(name) LIKE lower('%$search%') || lower(username) LIKE lower('%$search%')) $$ `status` = 0 ORDER BY id DESC limit 100";

    $users = mysqli_query($conn, $quser);
} else {
    $search = "Search Here...";
    $users = mysqli_query($conn, "SELECT `id`, `profile`, `name`,`status` FROM `users` WHERE `status` = 0 ORDER BY id DESC limit $start,$per_page");
}


// =====Pagination====

$totalUsers = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM `users`  WHERE `status` = 0"));
$totalPage = ceil($totalUsers / $per_page);

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Suspended Users</title>
    <link rel="stylesheet" href="css/table.css">
</head>

<style>
    input[type=search] {
        height: 40px;
        width: 70%;
        background-color: #e3e3e3;
        border-radius: 10px;
        margin: 10px auto;
        padding: 0px 10px;
        display: block;
        border: none;
        outline: none;
    }

    input[type=search]:focus {
        outline: 1px solid #e5e5e5;
    }
</style>

<body>
    <?php include_once('includes/header.php'); ?>


    <!-- =======================User LIST================ -->

    <form action="" method="get" id="search_f">
        <input type="search" name="q" id="search" placeholder="<?php echo $search ?>">
    </form>


    <table>

        <tr>
            <th>ID</th>
            <th>Pofile</th>
            <th>Name</th>
            <th>Status</th>
        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($users)) {

            $id = $r['id'];
            $name = $r['name'];
            $profile = $r['profile'];
            $status = $r['status'];
        ?>
            <tr>
                <td><?php echo $id ?></td>

                <?php
                if (strlen($profile) > 10) {
                ?>
                    <td><img src="<?php echo $profile ?>"></td>
                <?php
                } else {
                ?>
                    <td><img src="img/user.png"></td>
                <?php
                }
                ?>

                <td><?php echo $name ?></td>
                <?php
                if ($status == "0") {
                ?>
                 <td><input type="checkbox" onclick="userBlock('<?php echo $id ?>',this)" id="status"></td>
                     <?php
                } else {
                ?>
                    <td><input type="checkbox" checked onclick="userBlock('<?php echo $id ?>',this)" id="status"></td>
              
                <?php
                }
                ?>
            </tr>

        <?php
        }

        ?>



    </table>

    <!-- ===============Pagination=============== -->

    <div class="pagination">
        <a href="<?php
                    if ($page > 1) {
                        echo "?page=" . ($page - 1);
                    }
                    ?>">Pre</a>
        <?php
        for ($i = 1; $i <= $totalPage; $i++) {
            if ($i == $page) {
                echo "<a href='?page=" . $i . "' class='active'>" . $i . "</a>";
            } else {
                echo "<a href='?page=" . $i . "'>" . $i . "</a>";
            }
        ?>
        <?php
        }
        ?>
        <a href="<?php

                    if ($page < $totalPage) {
                        echo "?page=" . ($page + 1);
                    }
                    ?>">Next</a>
    </div>


    <!-- ================EXTRA JS===================== -->


    <script>
        function userBlock(id,check) {
            if (check.checked) {
                setBlock(id, "1");
            } else {
                setBlock(id, "0");
            }
        }

        function setBlock(id, status) {

            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    console.log(xhttp.responseText);
                }
            };

            let url = "crud/crud_block.php?id=" + id + "&status=" + status;
            xhttp.open("GET", url, true);
            xhttp.send();
        }
    </script>




    <?php include_once('includes/footer.php'); ?>