<?php
include 'session.php';

$category = mysqli_query($conn, "SELECT `id`, `name`,`cover` FROM `category` ORDER BY id DESC");


?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Category</title>
    <link rel="stylesheet" href="css/table.css">
</head>

<style>
    #cover {
        height: 60px;
        width: 100px;
        border-radius: 10px;
    }

    .button {
        display: flex;
        justify-content: end;
        align-items: center;
    }

    .button a {
        padding: 10px 20px;
        width: 120px;
        cursor: pointer;
        background-color: var(--color-primary);
        color: white;
        border-radius: 10px;
        margin: 20px;
    }

    #actions {
        text-align: center;
    }

    #actions a {
        margin-left: 15px;
        color: #004fe3;
    }

    #actions a i {
        font-size: 20px;
    }
</style>

<body>
    <?php include_once('includes/header.php'); ?>

    <div class="button">
        <a href="add_category.php">Add Category</a>
    </div>
    </div>

    <table>

        <tr>
            <th>ID</th>
            <th>Cover</th>
            <th>Category Name</th>
            <th>Actions</th>
        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($category)) {

            $id = $r['id'];
            $cover = $r['cover'];
            $name = $r['name'];

        ?>
            <tr>
                <td><?php echo $id ?></td>

                <?php
                if (strlen($cover) > 10) {
                ?>
                    <td><img src="<?php echo $cover ?>" id="cover"></td>
                <?php
                } else {
                ?>
                    <td><img src="img/cat.png" id="cover"></td>
                <?php
                }
                ?>

                <td><?php echo $name ?></td>

                <td id="actions">

                    <a href="edit_category.php?id=<?php echo $id ?>"><i class="fa fa-edit"></i></a>
                    <a href="#" onclick="deleteCat('<?php echo $id ?>')"><i class="fa fa-trash"></i></a>

                </td>

            </tr>

        <?php
        }

        ?>

    </table>


    <script>
        function deleteCat(id) {


            if (window.confirm("Are you sure want to delete it")) {
                var xhttp = new XMLHttpRequest();
                xhttp.onreadystatechange = function() {
                    if (this.readyState == 4 && this.status == 200) {

                        let res = xhttp.responseText;
                        if (res.includes("1")) {
                            location.reload();
                        } else {
                            alert("Failed To delete");

                        }
                    }
                };
                let url = "crud/delete_cat.php?id=" + id;
                xhttp.open("GET", url, true);
                xhttp.send();
            }
        }
    </script>

    <?php include_once('includes/footer.php'); ?>