<?php

require_once('app.php');

if (isset($_GET['page'])) {
    $page = $_GET['page'];
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}

$per_page = 30;

$start = ($page - 1) * $per_page;

$search_query = "";

$order_url = "";
$order_type = "latest";
$order_by = "ORDER BY id DESC";

$by_item_status = "status > 0";


if (isset($_GET['order'])) {

    $order_type = $_GET['order'];

    $order_url = "order=" . $order_type . "&";

    if ($order_type === "unverified") {

        $by_item_status = "status = 0";
    } else if ($order_type === "verified") {

        $by_item_status = "status = 1";
    } else if ($order_type == "all") {

        $by_item_status = "status >= 0";
    } else if ($order_type === "old") {

        $order_by = "ORDER BY id ASC";

    } else if ($order_type === "dual") {
        $by_item_status = "status = 1 && type = 'DUAL'";
        $order_by = "ORDER BY id DESC";
    } else if ($order_type === "live") {
        $by_item_status = "status = 1 && type = 'LIVE'";
        $order_by = "ORDER BY id DESC";
    }

    else {
        $order_by = "ORDER BY id DESC";
    }
} else if (isset($_GET['cat_id'])) {
    $cat_id = $_GET['cat_id'];
    $by_item_status = "category_id = $cat_id ";
}


$totalItems = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM wallpaper WHERE $by_item_status $order_by"));

if (isset($_GET['q'])) {

    $search = $_GET['q'];

    $search_query = "q=$search&";

    $qItem;
    if (is_numeric($search)) {
        $qItem = "SELECT * FROM `wallpaper` 
        WHERE id = $search && $by_item_status $order_by LIMIT 10";
    } else {
        $qItem = "SELECT * FROM wallpaper 
        WHERE lower(title) LIKE lower('%$search%') && $by_item_status $order_by LIMIT $start,$per_page";
    }

    $items = mysqli_query($conn, $qItem);

    $totalItems = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM wallpaper 
    WHERE lower(title) LIKE lower('%$search%') && $by_item_status $order_by"));
} else {

    $search = "Search Here...";
    $items = mysqli_query($conn, "SELECT * FROM wallpaper WHERE $by_item_status $order_by limit $start,$per_page");
}


// =====Pagination====
$totalPage = ceil($totalItems / $per_page);

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wallpapers</title>
    <link rel="stylesheet" href="css/table.css">
    <link rel="stylesheet" href="css/form.css">
    <link rel='icon' href='img/fav.png'>
</head>

<style>

</style>

<body>
    <?php include_once('includes/header.php'); ?>


    <div class="table_header">
        <div>
            <form action="" method="get" id="search_f">
                <input type="hidden" name="order" value="<?php echo $order_type ?>">

                <input type="search" name="q" id="search" placeholder="<?php echo $search ?>">
                <input type="submit" value="Search">
            </form>
        </div>

        <a href="wallpaper_add">Add More</a>

        <select name="order" id="order" onchange="changeOrder(this.value)">
            <option value="all" <?php echo $order_type == "all" ? "selected" : ""; ?>>All Wallpapers</option>
            <option value="unverified" <?php echo $order_type == "unverified" ? "selected" : ""; ?>>Disabled Wallpapers</option>
            <option value="verified" <?php echo $order_type == "verified" ? "selected" : ""; ?>>Enabled Wallpapers</option>
            <option value="latest" <?php echo $order_type == "latest" ? "selected" : ""; ?>>Latest Wallpapers</option>

            <option value="dual" <?php echo $order_type == "dual" ? "selected" : ""; ?>>Dual Wallpapers</option>
            <option value="live" <?php echo $order_type == "live" ? "selected" : ""; ?>>Live Wallpapers</option>
        </select>

        <script>
            function changeOrder(val) {
                let orderElement = document.createElement("a");
                orderElement.setAttribute("href", "?order=" + val);
                orderElement.click();
            }
        </script>

    </div>


    <table class="caption-top">
        <caption>Wallpapers</caption>

        <tr>
            <th>ID</th>
            <th>Cover</th>
            <th>Cover two</th>
            <th>Title</th>
            <th>Type</th>
            <th>Actions</th>
        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($items)) {

            $id = $r['id'];
            $title = $r['title'];
            $cover = $r['cover'];
            $cover_two = $r['cover_two'];
            $type = $r['type'];
            $status = $r['status'];
        ?>
            <tr>
                <td><?php echo $id ?></td>
                <td><img src="<?php echo getImages($cover); ?>" loading="lazy" id="cover"></td>
                <td><img src="<?php echo getImages($cover_two); ?>" loading="lazy" id="cover"></td>
                <td class="fill"><?php echo strlen($title) > 20 ? substr($title, 0, 20) . "..." : $title . "..."; ?></td>

                <td><?php echo $type ?></td>

                <td class="actions">
                    <input type="checkbox" <?php echo $status == "1" ? "checked" : ""; ?> onclick="changeStatus('<?php echo $id ?>',this)" id="status" title="Enable/Disable">
                    <a href="wallpaper_add?id=<?php echo $id ?>" class="dodgerblue"><i class="bx bx-edit"></i></a>
                    <?php if ($status == "0") {
                    ?>
                        <a onclick="deleteItem('<?php echo $id ?>')" class="red" title="Delete Permanently"><i class="bx bx-trash"></i></a>
                    <?php } ?>
                </td>
            </tr>

        <?php
        }

        ?>

    </table>

    <!-- ===============Pagination=============== -->

    <div class="pagination ">
        <a <?php if ($page > 1) {
                echo "href='?$order_url$search_query" . "page=" . $page - 1 . "'";
            }
            ?>>Pre</a>
        <?php
        for ($i = 1; $i <= $totalPage; $i++) {
            if ($i == $page) {
                echo "<a href='?$order_url$search_query" . "page=" . $i . "' class='active'>" . $i . "</a>";
            } else {
                echo "<a href='?$order_url$search_query" . "page=" . $i . "'>" . $i . "</a>";
            }
        ?>
        <?php
        }
        ?>
        <a <?php if ($page < $totalPage) {
                echo "href='?$order_url$search_query" . "page=" . $page + 1 . "'";
            }
            ?>>Next</a>
    </div>


    <!-- ================EXTRA JS===================== -->
    <!-- ===========================EXTRA SCRIPT============= -->

    <script>
        function changeStatus(id, check) {
            if (check.checked) {
                setStatus(id, "1");
            } else {
                setStatus(id, "0");
            }
        }

        function setStatus(id, status) {
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    console.log(xhttp.responseText);
                }
            };

            let url = "function.php?type=wallpaper_update&id=" + id + "&status=" + status;
            xhttp.open("GET", url, true);
            xhttp.send();
        }

        function deleteItem(id) {
            if (window.confirm("Are you sure want to delete it")) {
                var xhttp = new XMLHttpRequest();
                xhttp.onreadystatechange = function() {
                    if (this.readyState == 4 && this.status == 200) {
                        let res = xhttp.responseText;
                        if (res.includes("1")) {
                            location.reload();
                        } else {
                            alert("Failed To delete");
                        }
                    }
                };
                let url = "function.php?type=wallpaper_delete&id=" + id;
                xhttp.open("GET", url, true);
                xhttp.send();
            }
        }
    </script>

    <?php include_once('includes/footer.php'); ?>