<link rel="stylesheet" href="../asset/box/css/boxicons.min.css" />


<style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins&display=swap');

    * {
        margin: 0;
        padding: 0;
        font-family: 'Poppins', sans-serif;
        -webkit-tap-highlight-color: transparent;
        word-wrap: break-word;
        color: #606c8f;
        transition: all 0.3s;
    }

    a {
        text-decoration: none !important;
    }


    :root {
        --color-primary: #0056f5;
        --color-primary-rgb: 0, 86, 245;
        --color-primary-dark: #0151E6;
        --color-accent: #007FF5;
        --color-border: #dbdbdb;
        --color-dark-text: #60676b;
        --color-lite-text: #0000005D;
        --blue: #0056f5;
        --red: #ff5454;
        --green: #07b57e;
        --orange: orange;
        --dodgerblue: dodgerblue;
        --color-pagination: #0342ff;
    }

    body {
        background: linear-gradient(to left, #F7FCF5, #F3F7FC);
    }

    .red {
        color: #f7503a;
    }

    .green {
        color: #009b53;
    }

    .bg_red {
        background-color: #f7503a;
    }

    .bg_green {
        background-color: #009b53;
    }

    /* ================SCROLLBAR============= */

    /* width */
    /*::-webkit-scrollbar {*/
    /*    width: 3px;*/
    /*    height: 5px;*/
    /*}*/

    /* Track */
    /*::-webkit-scrollbar-track {*/
    /*    background: #F1F1F1F5;*/
    /*    margin-bottom: 80vh;*/
    /*}*/

    /* Handle */
    /*::-webkit-scrollbar-thumb {*/
    /*    background: #45A2FFF6;*/
    /*    margin-top: 200px;*/
    /*    margin-bottom: 200px;*/
    /*}*/

    /* Handle on hover */
    /*::-webkit-scrollbar-thumb:hover {*/
    /*    background: #0051FF;*/
    /*}*/



    /* ==============Header============== */
    header {
        padding: 0px 20px;
        position: sticky;
        top: 0px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        z-index: 10;
        height: 70px;
        border-bottom: 1px solid #F3F3F3;
        background-color: var(--color-primary-dark);
    }

    header #pageName {
        color: white;
        border-radius: 10px;
        padding: 5px 20px;
        font-weight: bolder;
    }

    header .menu {
        color: white;
        cursor: pointer;
        font-size: 30px;
        font-weight: bolder;
    }

    header .menu i {
        font-size: 35px;
        color: white;
    }

    header .menu span {
        margin-left: 20px;
        display: inline-block;
        text-transform: capitalize;
        color: white;
    }

    /* ===================Siderbar============== */


    aside {
        padding-top: 10px;
        height: calc(100vh - 100px);
        position: fixed;
        width: 230px;
        background-color: #FFF;
        transition: all 0.5s;
        z-index: 10;
        overflow-y: auto;
        border-right: 1px solid #F3F3F3;
    }

    aside a {
        display: block;
        padding: 10px 0;
        margin-top: 5px;
        margin-right: 5px;
        color: var(--color-dark-text);
        border-radius: 0 20px 20px 0;
        transition: all 0.5s;
        font-size: 14px;
    }

    aside a.active,
    aside a:hover {
        color: #FFFFFF !important;
        background-color: var(--color-primary-dark) !important;
    }

    aside a.active i,
    aside a:hover i {
        color: #FFFFFF !important;
    }


    aside a i {
        margin: 0px 20px;
        font-size: 20px;
    }

    /* ==============Main============= */

    #main {
        background-color: white;
        padding: 10px;
        border-radius: 10px;
        max-width: 100vw;
        overflow-x: auto;
        padding-bottom: 100px;
    }

    /* ==============Media Query========== */

    @media screen and (min-width: 700px) {

        #main {
            margin: 20px 20px 20px 250px;
        }

        #main.small {
            margin: 20px;
        }

        aside {
            left: 0px;
        }

        aside.open {
            left: -230px;
        }

        header .menu {
            font-size: 20px;
        }

    }

    @media screen and (max-width: 700px) {

        aside {
            left: -230px;
        }

        aside.open {
            left: 0px;
        }

        header .menu {
            font-size: 12px;
        }
    }


    .border {
        border: 1px solid var(--color-border);
        padding: 0 10px;
    }
</style>



<!-- ====================Header============== -->

<header>

    <div class="menu" id="menu-toggle">
        <i class="fa-solid fa-bars"></i>
        <span>
            <script>
                document.write(document.title);
            </script>
        </span>
    </div>

    <div id="pageName">

    </div>

</header>

<!-- ====================Siderbar=============== -->


<aside id="sidebar">

    <a href="/dashboard">
        <i class='bx bxs-dashboard'></i>Dashboard
    </a>

    <a href="/wallpaper">
        <i class='bx bxs-image'></i>Wallpaper
    </a>


    <a href="/category">
        <i class='bx bx-category'></i>Category
    </a>


    <a href="/sliders">
        <i class='bx bx-images'></i>Sliders
    </a>

    <a href="/notification">
        <i class='bx bxs-bell'></i> Notifications
    </a>

    <a href="/settings">
        <i class='bx bx-cog'></i>Settings
    </a>

    <a href="/ads">
        <i class='bx bx-dollar-circle'></i>Ads
    </a>

    <a href="?logout=user">
        <i class='bx bx-power-off'></i>Logout
    </a>

</aside>

<main id="main">