<?php

require_once('app.php');

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php
            echo APP_NAME;
            ?></title>
    <link rel='icon' href='img/fav.png'>
</head>

<style>
    .dashboards {
        display: flex;
        flex-direction: column;
        gap: 25px;
    }

    .dashboard {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
        grid-gap: 20px;
        background-color: white;
        border-radius: 25px;
        padding: 20px;
        padding-top: 20px;
    }

    .dashboard a {
        color: #FFFFFF;
        display: flex;
        height: auto;
        align-items: center;
        cursor: pointer;
        border-left: 3px solid var(--color-primary);
        border-radius: 0px 20px 20px 0px;
        gap: 10px;
        background: linear-gradient(to right, rgba(var(--color-primary-rgb), 0.07), rgba(var(--color-primary-rgb), 0.02));
        border-radius: 0px 10px 10px 0px;
        transition: 1s linear;
    }

    .dashboard a:hover {
        background: linear-gradient(to right, var(--color-primary), var(--color-accent));
    }

    .dashboard a:hover i {
        color: white;
        background-color: rgba(0, 0, 0, 0.2);
    }

    .dashboard a:hover .details span:nth-child(1) {
        color: white;
    }

    .dashboard a:hover .details span:nth-child(2) {
        color: white;
    }

    .dashboard a i {
        font-size: 20px;
        height: 20px;
        width: 20px;
        padding: 16px;
        display: flex;
        justify-content: center;
        align-items: center;
        background-color: rgba(var(--color-primary-rgb), 0.05);
        border-radius: 50%;
        margin: 10px;
        color: var(--color-primary);
    }

    .dashboard a .details {
        display: flex;
        flex-direction: column;
    }

    .dashboard a .details span:nth-child(1) {
        font-size: 18px;
        font-weight: bold;
        color: var(--color-primary);
    }

    .dashboard a .details span:nth-child(2) {
        font-size: 14px;
        color: var(--color-lite-text);
    }


    /* -------------- green ------------- */

    .dashboard a.green {
        border-left: 3px solid #80ab0a;
        background: linear-gradient(to right, rgba(128, 171, 10, 0.07), rgba(128, 171, 10, 0.02));
    }


    .dashboard a.green i {
        background-color: rgba(128, 171, 10, 0.05);
        color: #80ab0a;
    }

    .dashboard a.green .details span:nth-child(1) {
        color: #80ab0a;
    }

    .dashboard a.green:hover {
        background: linear-gradient(to right, #80ab0a, #80ab0a);
    }

    .dashboard a.green:hover i {
        color: white;
        background-color: rgba(0, 0, 0, 0.2);
    }

    .dashboard a.green:hover .details span:nth-child(1) {
        color: white;
    }


    /* -------------- orange ------------- */

    .dashboard a.orange {
        border-left: 3px solid #ff8400;
        background: linear-gradient(to right, rgba(255, 132, 0, 0.07), rgba(255, 132, 0, 0.02));
    }


    .dashboard a.orange i {
        background-color: rgba(255, 132, 0, 0.05);
        color: #ff8400;
    }

    .dashboard a.orange .details span:nth-child(1) {
        color: #ff8400;
    }

    .dashboard a.orange:hover {
        background: linear-gradient(to right, #ff8400, #ff8400);
    }

    .dashboard a.orange:hover i {
        color: white;
        background-color: rgba(0, 0, 0, 0.2);
    }

    .dashboard a.orange:hover .details span:nth-child(1) {
        color: white;
    }


    /* -------------- blue ------------- */

    .dashboard a.blue {
        border-left: 3px solid #00a2ff;
        background: linear-gradient(to right, rgba(0, 162, 255, 0.07), rgba(0, 162, 255, 0.02));
    }


    .dashboard a.blue i {
        background-color: rgba(0, 162, 255, 0.05);
        color: #00a2ff;
    }

    .dashboard a.blue .details span:nth-child(1) {
        color: #00a2ff;
    }

    .dashboard a.blue:hover {
        background: linear-gradient(to right, #00a2ff, #00a2ff);
    }

    .dashboard a.blue:hover i {
        color: white;
        background-color: rgba(0, 0, 0, 0.2);
    }

    .dashboard a.blue:hover .details span:nth-child(1) {
        color: white;
    }

    /* -------------- red ------------- */


    .dashboard a.red {
        border-left: 3px solid #ff0048;
        background: linear-gradient(to right, rgba(255, 0, 72, 0.07), rgba(255, 0, 72, 0.02));
    }


    .dashboard a.red i {
        background-color: rgba(255, 0, 72, 0.05);
        color: #ff0048;
    }

    .dashboard a.red .details span:nth-child(1) {
        color: #ff0048;
    }

    .dashboard a.red:hover {
        background: linear-gradient(to right, #ff0048, #ff0048);
    }

    .dashboard a.red:hover i {
        color: white;
        background-color: rgba(0, 0, 0, 0.2);
    }

    .dashboard a.red:hover .details span:nth-child(1) {
        color: white;
    }



    /* -------------- yellow ------------- */

    .dashboard a.yellow {
        border-left: 3px solid #d4bf06;
        background: linear-gradient(to right, rgba(212, 191, 6, 0.07), rgba(212, 191, 6, 0.02));
    }


    .dashboard a.yellow i {
        background-color: rgba(212, 191, 6, 0.05);
        color: #d4bf06;
    }

    .dashboard a.yellow .details span:nth-child(1) {
        color: #d4bf06;
    }

    .dashboard a.yellow:hover {
        background: linear-gradient(to right, #d4bf06, #d4bf06);
    }

    .dashboard a.yellow:hover i {
        color: white;
        background-color: rgba(0, 0, 0, 0.2);
    }

    .dashboard a.yellow:hover .details span:nth-child(1) {
        color: white;
    }


    /* -------------- purple ------------- */
    .dashboard a.purple {
        border-left: 3px solid #8c00e3;
        background: linear-gradient(to right, rgba(140, 0, 227, 0.07), rgba(140, 0, 227, 0.02));
    }

    .dashboard a.purple i {
        background-color: rgba(140, 0, 227, 0.05);
        color: #8c00e3;
    }

    .dashboard a.purple .details span:nth-child(1) {
        color: #8c00e3;
    }

    .dashboard a.purple:hover {
        background: linear-gradient(to right, #8c00e3, #8c00e3);
    }

    .dashboard a.purple:hover i {
        color: white;
        background-color: rgba(0, 0, 0, 0.2);
    }

    .dashboard a.purple:hover .details span:nth-child(1) {
        color: white;
    }
</style>

<body>

    <?php include_once('includes/header.php'); ?>


    <?php

    $category = counter(mysqli_num_rows(mysqli_query(getConn(), "SELECT `id` FROM category")));
    $wallpaper = counter(mysqli_num_rows(mysqli_query(getConn(), "SELECT `id` FROM wallpaper")));
    $total_sliders = counter(mysqli_num_rows(mysqli_query(getConn(), "SELECT `id` FROM sliders")));


    ?>


    <div class="dashboards">


        <div class="dashboard">

            <a href="/category" class="red">
                <i class='bx bx-category'></i>
                <div class="details">
                    <span><?php echo $category ?></span>
                    <span>Category</span>
                </div>
            </a>

            <a href="/wallpaper" class="purple">
                <i class='bx bx-image-alt'></i>

                <div class="details">
                    <span><?php echo $wallpaper ?></span>
                    <span>Wallpaper</span>
                </div>
            </a>

            <a href="/sliders" class="orange">
                <i class="bx bx-images"></i>
                <div class="details">
                    <span><?php echo $total_sliders ?></span>
                    <span>Sliders</span>
                </div>
            </a>


            <a href="/notification" class="blue">
                <i class="bx bx-bell"></i>
                <div class="details">
                    <span></span>
                    <span>Send Notification</span>
                </div>
            </a>

            <a href="/settings"  class="yellow">
                <i class='bx bx-cog'></i>
                <div class="details">
                    <span></span>
                    <span>Settings</span>
                </div>

            </a>


        </div>
    </div>



    <?php include_once('includes/footer.php'); ?>